/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.systems;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuFence;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.shaders.ShaderType;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.ScissorState;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;

@fic
public class RenderSystem {
    public static final ScissorState SCISSOR_STATE = new ScissorState();
    static final Logger LOGGER = LogUtils.getLogger();
    public static final int MINIMUM_ATLAS_TEXTURE_SIZE = 1024;
    @Nullable
    private static Thread renderThread;
    @Nullable
    private static GpuDevice DEVICE;
    private static double lastDrawTime;
    private static final a sharedSequential;
    private static final a sharedSequentialQuad;
    private static final a sharedSequentialLines;
    private static Matrix4f projectionMatrix;
    private static Matrix4f savedProjectionMatrix;
    private static fig projectionType;
    private static fig savedProjectionType;
    private static final Matrix4fStack modelViewStack;
    private static Matrix4f textureMatrix;
    public static final int TEXTURE_COUNT = 12;
    private static final GpuTexture[] shaderTextures;
    private static final float[] shaderColor;
    private static float shaderGlintAlpha;
    private static grb shaderFog;
    private static final Vector3f[] shaderLightDirections;
    private static float shaderGameTime;
    private static final Vector3f modelOffset;
    private static float shaderLineWidth;
    private static String apiDescription;
    private static final AtomicLong pollEventsWaitStart;
    private static final AtomicBoolean pollingEvents;
    @Nullable
    private static GpuBuffer QUAD_VERTEX_BUFFER;
    private static final ayk<b> PENDING_FENCES;

    public static void initRenderThread() {
        if (renderThread != null) {
            throw new IllegalStateException("Could not initialize render thread");
        }
        renderThread = Thread.currentThread();
    }

    public static boolean isOnRenderThread() {
        return Thread.currentThread() == renderThread;
    }

    public static void assertOnRenderThread() {
        if (!RenderSystem.isOnRenderThread()) {
            throw RenderSystem.constructThreadException();
        }
    }

    private static IllegalStateException constructThreadException() {
        return new IllegalStateException("Rendersystem called from wrong thread");
    }

    private static void pollEvents() {
        pollEventsWaitStart.set(ag.c());
        pollingEvents.set(true);
        GLFW.glfwPollEvents();
        pollingEvents.set(false);
    }

    public static boolean isFrozenAtPollEvents() {
        return pollingEvents.get() && ag.c() - pollEventsWaitStart.get() > 200L;
    }

    public static void flipFrame(long $$0, @Nullable fii $$1) {
        RenderSystem.pollEvents();
        flf.b().c();
        GLFW.glfwSwapBuffers((long)$$0);
        if ($$1 != null) {
            $$1.b();
        }
        RenderSystem.pollEvents();
    }

    public static void limitDisplayFPS(int $$0) {
        double $$1 = lastDrawTime + 1.0 / (double)$$0;
        double $$2 = GLFW.glfwGetTime();
        while ($$2 < $$1) {
            GLFW.glfwWaitEventsTimeout((double)($$1 - $$2));
            $$2 = GLFW.glfwGetTime();
        }
        lastDrawTime = $$2;
    }

    public static void enableScissor(int $$0, int $$1, int $$2, int $$3) {
        SCISSOR_STATE.enable($$0, $$1, $$2, $$3);
    }

    public static void disableScissor() {
        SCISSOR_STATE.disable();
    }

    public static void setShaderFog(grb $$0) {
        RenderSystem.assertOnRenderThread();
        shaderFog = $$0;
    }

    public static grb getShaderFog() {
        RenderSystem.assertOnRenderThread();
        return shaderFog;
    }

    public static void setShaderGlintAlpha(double $$0) {
        RenderSystem.setShaderGlintAlpha((float)$$0);
    }

    public static void setShaderGlintAlpha(float $$0) {
        RenderSystem.assertOnRenderThread();
        shaderGlintAlpha = $$0;
    }

    public static float getShaderGlintAlpha() {
        RenderSystem.assertOnRenderThread();
        return shaderGlintAlpha;
    }

    public static void setShaderLights(Vector3f $$0, Vector3f $$1) {
        RenderSystem.assertOnRenderThread();
        RenderSystem.shaderLightDirections[0] = $$0;
        RenderSystem.shaderLightDirections[1] = $$1;
    }

    public static Vector3f[] getShaderLights() {
        return shaderLightDirections;
    }

    public static void setShaderColor(float $$0, float $$1, float $$2, float $$3) {
        RenderSystem.assertOnRenderThread();
        RenderSystem.shaderColor[0] = $$0;
        RenderSystem.shaderColor[1] = $$1;
        RenderSystem.shaderColor[2] = $$2;
        RenderSystem.shaderColor[3] = $$3;
    }

    public static float[] getShaderColor() {
        RenderSystem.assertOnRenderThread();
        return shaderColor;
    }

    public static void lineWidth(float $$0) {
        RenderSystem.assertOnRenderThread();
        shaderLineWidth = $$0;
    }

    public static float getShaderLineWidth() {
        RenderSystem.assertOnRenderThread();
        return shaderLineWidth;
    }

    public static String getBackendDescription() {
        return String.format(Locale.ROOT, "LWJGL version %s", GLX._getLWJGLVersion());
    }

    public static String getApiDescription() {
        return apiDescription;
    }

    public static bbc.a initBackendSystem() {
        return GLX._initGlfw()::getAsLong;
    }

    public static void initRenderer(long $$0, int $$1, boolean $$2, BiFunction<alr, ShaderType, String> $$3, boolean $$4) {
        DEVICE = new fjg($$0, $$1, $$2, $$3, $$4);
        apiDescription = RenderSystem.getDevice().getImplementationInformation();
        try (fla $$5 = new fla(flb.e.getVertexSize() * 4);){
            fkz $$6 = new fkz($$5, VertexFormat.b.h, flb.e);
            $$6.a(0.0f, 0.0f, 0.0f);
            $$6.a(1.0f, 0.0f, 0.0f);
            $$6.a(1.0f, 1.0f, 0.0f);
            $$6.a(0.0f, 1.0f, 0.0f);
            try (flc $$7 = $$6.b();){
                QUAD_VERTEX_BUFFER = RenderSystem.getDevice().createBuffer(() -> "Quad", BufferType.VERTICES, BufferUsage.STATIC_WRITE, $$7.a());
            }
        }
    }

    public static void setErrorCallback(GLFWErrorCallbackI $$0) {
        GLX._setGlfwErrorCallback($$0);
    }

    public static void setupDefaultState() {
        projectionMatrix.identity();
        savedProjectionMatrix.identity();
        modelViewStack.clear();
        textureMatrix.identity();
    }

    public static void setupOverlayColor(@Nullable GpuTexture $$0) {
        RenderSystem.assertOnRenderThread();
        RenderSystem.setShaderTexture(1, $$0);
    }

    public static void teardownOverlayColor() {
        RenderSystem.assertOnRenderThread();
        RenderSystem.setShaderTexture(1, null);
    }

    public static void setupLevelDiffuseLighting(Vector3f $$0, Vector3f $$1) {
        RenderSystem.assertOnRenderThread();
        RenderSystem.setShaderLights($$0, $$1);
    }

    public static void setupGuiFlatDiffuseLighting(Vector3f $$0, Vector3f $$1) {
        RenderSystem.assertOnRenderThread();
        Matrix4f $$2 = new Matrix4f().rotationY(-0.3926991f).rotateX(2.3561945f);
        RenderSystem.setShaderLights($$2.transformDirection((Vector3fc)$$0, new Vector3f()), $$2.transformDirection((Vector3fc)$$1, new Vector3f()));
    }

    public static void setupGui3DDiffuseLighting(Vector3f $$0, Vector3f $$1) {
        RenderSystem.assertOnRenderThread();
        Matrix4f $$2 = new Matrix4f().scaling(1.0f, -1.0f, 1.0f).rotateYXZ(1.0821041f, 3.2375858f, 0.0f).rotateYXZ(-0.3926991f, 2.3561945f, 0.0f);
        RenderSystem.setShaderLights($$2.transformDirection((Vector3fc)$$0, new Vector3f()), $$2.transformDirection((Vector3fc)$$1, new Vector3f()));
    }

    public static void setShaderTexture(int $$0, @Nullable GpuTexture $$1) {
        RenderSystem.assertOnRenderThread();
        if ($$0 >= 0 && $$0 < shaderTextures.length) {
            RenderSystem.shaderTextures[$$0] = $$1;
        }
    }

    @Nullable
    public static GpuTexture getShaderTexture(int $$0) {
        RenderSystem.assertOnRenderThread();
        if ($$0 >= 0 && $$0 < shaderTextures.length) {
            return shaderTextures[$$0];
        }
        return null;
    }

    public static void setProjectionMatrix(Matrix4f $$0, fig $$1) {
        RenderSystem.assertOnRenderThread();
        projectionMatrix = new Matrix4f((Matrix4fc)$$0);
        projectionType = $$1;
    }

    public static void setTextureMatrix(Matrix4f $$0) {
        RenderSystem.assertOnRenderThread();
        textureMatrix = new Matrix4f((Matrix4fc)$$0);
    }

    public static void resetTextureMatrix() {
        RenderSystem.assertOnRenderThread();
        textureMatrix.identity();
    }

    public static void backupProjectionMatrix() {
        RenderSystem.assertOnRenderThread();
        savedProjectionMatrix = projectionMatrix;
        savedProjectionType = projectionType;
    }

    public static void restoreProjectionMatrix() {
        RenderSystem.assertOnRenderThread();
        projectionMatrix = savedProjectionMatrix;
        projectionType = savedProjectionType;
    }

    public static Matrix4f getProjectionMatrix() {
        RenderSystem.assertOnRenderThread();
        return projectionMatrix;
    }

    public static Matrix4f getModelViewMatrix() {
        RenderSystem.assertOnRenderThread();
        return modelViewStack;
    }

    public static Matrix4fStack getModelViewStack() {
        RenderSystem.assertOnRenderThread();
        return modelViewStack;
    }

    public static Matrix4f getTextureMatrix() {
        RenderSystem.assertOnRenderThread();
        return textureMatrix;
    }

    public static a getSequentialBuffer(VertexFormat.b $$0) {
        RenderSystem.assertOnRenderThread();
        return switch ($$0) {
            case VertexFormat.b.h -> sharedSequentialQuad;
            case VertexFormat.b.a -> sharedSequentialLines;
            default -> sharedSequential;
        };
    }

    public static void setShaderGameTime(long $$0, float $$1) {
        RenderSystem.assertOnRenderThread();
        shaderGameTime = ((float)($$0 % 24000L) + $$1) / 24000.0f;
    }

    public static float getShaderGameTime() {
        RenderSystem.assertOnRenderThread();
        return shaderGameTime;
    }

    public static fig getProjectionType() {
        RenderSystem.assertOnRenderThread();
        return projectionType;
    }

    public static GpuBuffer getQuadVertexBuffer() {
        if (QUAD_VERTEX_BUFFER == null) {
            throw new IllegalStateException("Can't getQuadVertexBuffer() before renderer was initialized");
        }
        return QUAD_VERTEX_BUFFER;
    }

    public static void setModelOffset(float $$0, float $$1, float $$2) {
        RenderSystem.assertOnRenderThread();
        modelOffset.set($$0, $$1, $$2);
    }

    public static void resetModelOffset() {
        RenderSystem.assertOnRenderThread();
        modelOffset.set(0.0f, 0.0f, 0.0f);
    }

    public static Vector3f getModelOffset() {
        RenderSystem.assertOnRenderThread();
        return modelOffset;
    }

    public static void queueFencedTask(Runnable $$0) {
        PENDING_FENCES.addLast(new b($$0, new GpuFence()));
    }

    public static void executePendingTasks() {
        b $$0 = PENDING_FENCES.peekFirst();
        while ($$0 != null) {
            if ($$0.b.awaitCompletion(0L)) {
                try {
                    $$0.a.run();
                }
                finally {
                    $$0.b.close();
                }
                PENDING_FENCES.removeFirst();
                $$0 = PENDING_FENCES.peekFirst();
                continue;
            }
            return;
        }
    }

    public static GpuDevice getDevice() {
        if (DEVICE == null) {
            throw new IllegalStateException("Can't getDevice() before it was initialized");
        }
        return DEVICE;
    }

    @Nullable
    public static GpuDevice tryGetDevice() {
        return DEVICE;
    }

    static {
        lastDrawTime = Double.MIN_VALUE;
        sharedSequential = new a(1, 1, java.util.function.IntConsumer::accept);
        sharedSequentialQuad = new a(4, 6, ($$0, $$1) -> {
            $$0.accept($$1);
            $$0.accept($$1 + 1);
            $$0.accept($$1 + 2);
            $$0.accept($$1 + 2);
            $$0.accept($$1 + 3);
            $$0.accept($$1);
        });
        sharedSequentialLines = new a(4, 6, ($$0, $$1) -> {
            $$0.accept($$1);
            $$0.accept($$1 + 1);
            $$0.accept($$1 + 2);
            $$0.accept($$1 + 3);
            $$0.accept($$1 + 2);
            $$0.accept($$1 + 1);
        });
        projectionMatrix = new Matrix4f();
        savedProjectionMatrix = new Matrix4f();
        projectionType = fig.a;
        savedProjectionType = fig.a;
        modelViewStack = new Matrix4fStack(16);
        textureMatrix = new Matrix4f();
        shaderTextures = new GpuTexture[12];
        shaderColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        shaderGlintAlpha = 1.0f;
        shaderFog = grb.a;
        shaderLightDirections = new Vector3f[2];
        modelOffset = new Vector3f();
        shaderLineWidth = 1.0f;
        apiDescription = "Unknown";
        pollEventsWaitStart = new AtomicLong();
        pollingEvents = new AtomicBoolean(false);
        PENDING_FENCES = new ayk();
    }

    public static final class com.mojang.blaze3d.systems.RenderSystem$a {
        private final int a;
        private final int b;
        private final a c;
        @Nullable
        private GpuBuffer d;
        private VertexFormat.a e = VertexFormat.a.a;
        private int f;

        com.mojang.blaze3d.systems.RenderSystem$a(int $$0, int $$1, a $$2) {
            this.a = $$0;
            this.b = $$1;
            this.c = $$2;
        }

        public boolean a(int $$0) {
            return $$0 <= this.f;
        }

        public GpuBuffer b(int $$0) {
            this.c($$0);
            return this.d;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void c(int $$0) {
            if (this.a($$0)) {
                return;
            }
            $$0 = azz.d($$0 * 2, this.b);
            LOGGER.debug("Growing IndexBuffer: Old limit {}, new limit {}.", (Object)this.f, (Object)$$0);
            int $$1 = $$0 / this.b;
            int $$2 = $$1 * this.a;
            VertexFormat.a $$3 = VertexFormat.a.a($$2);
            int $$4 = azz.d($$0 * $$3.c, 4);
            ByteBuffer $$5 = MemoryUtil.memAlloc((int)$$4);
            try {
                this.e = $$3;
                IntConsumer $$6 = this.a($$5);
                for (int $$7 = 0; $$7 < $$0; $$7 += this.b) {
                    this.c.accept($$6, $$7 * this.a / this.b);
                }
                $$5.flip();
                if (this.d != null) {
                    this.d.close();
                }
                this.d = RenderSystem.getDevice().createBuffer(() -> "Auto Storage index buffer", BufferType.INDICES, BufferUsage.DYNAMIC_WRITE, $$5);
            }
            finally {
                MemoryUtil.memFree((Buffer)$$5);
            }
            this.f = $$0;
        }

        private IntConsumer a(ByteBuffer $$0) {
            switch (this.e) {
                case a: {
                    return $$1 -> $$0.putShort((short)$$1);
                }
            }
            return $$0::putInt;
        }

        public VertexFormat.a a() {
            return this.e;
        }

        static interface a {
            public void accept(IntConsumer var1, int var2);
        }
    }

    static final class b
    extends Record {
        final Runnable a;
        final GpuFence b;

        b(Runnable $$0, GpuFence $$1) {
            this.a = $$0;
            this.b = $$1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "callback;fence", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "callback;fence", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object $$0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "callback;fence", "a", "b"}, this, $$0);
        }

        public Runnable a() {
            return this.a;
        }

        public GpuFence b() {
            return this.b;
        }
    }
}

